/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <stdlib.h>
#include "dma_api_DSP.h"
#include "metypes.h"
#define IVPD 0x000049
#define IVPH 0x00004A
#define IER0 0x000000
#define IER1 0x000045
#define DSP_WDT_TIMER_MODE		0x3404
#define DMA_channel_0 18        //IER1
#define DMA_channel_2 20        //IER1
#define DMA_channel_3 21        //IER1
#define DMA_channel_1 9         //IER0
#define DMA_channel_4 14        //IER0
#define DMA_channel_5 15        //IER0 //priority DMA_channel_1 DMA_channel_4 5 0 2 3

volatile int flag[6];

FuncPtr_t funptr[6];

interrupt void
DMA_ISR_0()
{
    flag[0] = 1;
}

interrupt void
DMA_ISR_1()
{
    flag[1] = 1;
    //stop_dma_in_1();
}

interrupt void
DMA_ISR_2()
{
    flag[2] = 1;
}

interrupt void
DMA_ISR_3()
{
    flag[3] = 1;
}

interrupt void
DMA_ISR_4()
{
    flag[4] = 1;
}

interrupt void
DMA_ISR_5()
{
    flag[5] = 1;
}

void
install_DMAISR_5()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += (15) << 3;        //vector += DMA_channel_4 << 3;//0x148
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_5;
    *(uint16 *) IER0 |= (uint16) (1 << 15);  //*(uint16*)IER0 |= 1 << DMA_channel_4;
    asm("	BCLR ST1_INTM");
}

void
install_DMAISR_4()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += (14) << 3;        //vector += DMA_channel_4 << 3;//0x148
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_4;
    *(uint16 *) IER0 |= 1 << (14);  //*(uint16*)IER0 |= 1 << DMA_channel_4;
    asm("	BCLR ST1_INTM");
}

void
install_DMAISR_3()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += (21) << 3;        //0x148 i=2=>20
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_3;
    *(uint16 *) IER1 |= 1 << (5);
    asm("	BCLR ST1_INTM");
}

void
install_DMAISR_2()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += (20) << 3;        //0x148 i=2=>20
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_2;
    *(uint16 *) IER1 |= 1 << (4);
    asm("	BCLR ST1_INTM");
}

void
install_DMAISR_1()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += DMA_channel_1 << 3;
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_1;
    *(uint16 *) IER0 |= 1 << DMA_channel_1;
    asm("	BCLR ST1_INTM");
}

void
install_DMAISR_0()
{
    uint32  vector;
    asm("	BSET ST1_INTM");
    vector = *(uint16 *) IVPH << 8;
    vector += DMA_channel_0 << 3;
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) DMA_ISR_0; //0x6A000000 to 0x0//2008/1/18 12:21W
    *(uint16 *) IER1 |= 1 << (2);   //DMA_channel_0-16
    asm("	BCLR ST1_INTM");
}

void
disable_watchdog_timer()
{
    if (*(ioport uint16 *) DSP_WDT_TIMER_MODE & 0x8000)
    {
        *(ioport uint16 *) DSP_WDT_TIMER_MODE = 0xF5;
        *(ioport uint16 *) DSP_WDT_TIMER_MODE = 0xA0;
    }
}
void
enable_global_interrupt()
{
    int     i;
    uint32  vector;
    funptr[0] = install_DMAISR_0;
    funptr[1] = install_DMAISR_1;
    funptr[2] = install_DMAISR_2;
    funptr[3] = install_DMAISR_3;
    funptr[4] = install_DMAISR_4;
    funptr[5] = install_DMAISR_5;

    disable_watchdog_timer();
    asm("	BSET ST1_INTM");
    *(uint16 *) IVPD = (0x58);  //0x5800 .cmd
    *(uint16 *) IVPH = (0x58);
    asm("	BCLR ST1_INTM");
    vector = *(uint16 *) IVPD << 8;
    for (i = 0; i < 32; i++)
    {
        *(uint32 *) (vector / 2) = 0x6A000000;  //0x6A000000 to 0x0//2008/1/18 12:21W
        vector += 4;
        *(uint32 *) (vector / 2) = 0x20202020;
        vector += 4;
    }
    for (i = 0; i < 6; i++)
        flag[i] = 1;
    for (i = 0; i < 6; i++)     //?
        funptr[i] ();
}

int
dma_api_ssd_pd(dma_port srcp, dma_port dstp, dma_channel cha)   //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    //(*(ioport unsigned short *)(DSP_DMA_CSEI0+(i<<5)))=srcp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CSFI0+(i<<5)))=srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_SARAM | DSP_DMA_CSDP_DST_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_POSTINCREMENT | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_dsd_pd(dma_port srcp, dma_port dstp, dma_channel cha)   //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    //(*(ioport unsigned short *)(DSP_DMA_CSEI0+(i<<5)))=srcp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CSFI0+(i<<5)))=srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_DARAM | DSP_DMA_CSDP_DST_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_POSTINCREMENT | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sdd_dd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_DST_DARAM | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;   //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_ds_dd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_DARAM | DSP_DMA_CSDP_DST_SARAM | DSP_DMA_CSDP_DATATYPE_16BITS;   //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;   //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sdd_dp(dma_port srcp, dma_port dstp, dma_channel cha)   //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDEI0+(i<<5)))=dstp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDFI0+(i<<5)))=dstp.addressing_frmIndex;  

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DST_DARAM | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_POSTINCREMENT | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sds_dp(dma_port srcp, dma_port dstp, dma_channel cha)   //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDEI0+(i<<5)))=dstp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDFI0+(i<<5)))=dstp.addressing_frmIndex;  

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DST_SARAM | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_POSTINCREMENT | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_dd_dd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_DARAM | DSP_DMA_CSDP_DST_DARAM | DSP_DMA_CSDP_DATATYPE_16BITS;   //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;   //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_dd_cd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    //(*(ioport unsigned short *)(DSP_DMA_CSEI0+(i<<5)))=srcp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CSFI0+(i<<5)))=srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_DARAM | DSP_DMA_CSDP_DST_DARAM | DSP_DMA_CSDP_DATATYPE_16BITS;   //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_CONSTANT | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;  //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sdsd_dp(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDEI0+(i<<5)))=dstp.addressing_elmIndex;
    //(*(ioport unsigned short *)(DSP_DMA_CDFI0+(i<<5)))=dstp.addressing_frmIndex;  

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DST_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS; //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_POSTINCREMENT | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_ssd_dd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_SARAM | DSP_DMA_CSDP_DST_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;   //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sdsd_dd(dma_port srcp, dma_port dstp, dma_channel cha)
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSEI0 + (i << 5))) =
        srcp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CSFI0 + (i << 5))) =
        srcp.addressing_frmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDEI0 + (i << 5))) =
        dstp.addressing_elmIndex;
    (*(ioport unsigned short *) (DSP_DMA_CDFI0 + (i << 5))) =
        dstp.addressing_frmIndex;

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DST_EMIF | DSP_DMA_CSDP_DATATYPE_16BITS; //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI;   //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_ss_pp(dma_port srcp, dma_port dstp, dma_channel cha)    //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_SARAM | DSP_DMA_CSDP_DST_SARAM | DSP_DMA_CSDP_DATATYPE_16BITS;   //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_POSTINCREMENT | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}

int
dma_api_sds_pp(dma_port srcp, dma_port dstp, dma_channel cha)   //iframe copy cur.
{
    int     i = cha.channel_number;
    (*(ioport unsigned short *) DSP_DMA_GCR) = DSP_DMA_GCR_BASE | DSP_DMA_GCR_FREE_DISABLE; //0x000c
    (*(ioport unsigned short *) DSP_DMA_GSCR) = DSP_DMA_GSCR_BASE | DSP_DMA_GSCR_DINDXMD_COMPATIBILITY; //0x0000
    (*(ioport unsigned short *) DSP_DMA_GTCR) = DSP_DMA_GTCR_BASE | DSP_DMA_GTCR_DTCE_ENABLE | DSP_DMA_GTCR_STCE_ENABLE;    //0x0000DARAM timeout and SARAM timeout Enable

    flag[i] = (*(ioport unsigned short *) (DSP_DMA_CSR0 + (i << 5)));   //0x20*i
    flag[i] = 0;
    srcp.staddr = (srcp.staddr << 1);
    dstp.staddr = (dstp.staddr << 1);

    (*(ioport unsigned short *) (DSP_DMA_CSSA_L0 + (i << 5))) = ((uint32) srcp.staddr & 0xFFFF);    //byte addressing
    (*(ioport unsigned short *) (DSP_DMA_CSSA_U0 + (i << 5))) =
        ((uint32) srcp.staddr >> 16);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_L0 + (i << 5))) =
        ((uint32) dstp.staddr & 0xFFFF);
    (*(ioport unsigned short *) (DSP_DMA_CDSA_U0 + (i << 5))) =
        ((uint32) dstp.staddr >> 16);

    (*(ioport unsigned short *) (DSP_DMA_CSDP0 + (i << 5))) = DSP_DMA_CSDP_BASE | DSP_DMA_CSDP_SRC_EMIF | DSP_DMA_CSDP_DST_SARAM | DSP_DMA_CSDP_DATATYPE_16BITS;    //be ware of DATABYTE
    (*(ioport unsigned short *) (DSP_DMA_CEN0 + (i << 5))) = cha.elmCnt;    //size;
    (*(ioport unsigned short *) (DSP_DMA_CFN0 + (i << 5))) = cha.frmCnt;    //1

    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) = DSP_DMA_CCR_BASE | DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX | DSP_DMA_CCR_SRCAMODE_POSTINCREMENT | DSP_DMA_CCR_AUTOINIT_DISABLE | DSP_DMA_CCR_PRIO_HI; //|DSP_DMA_CCR_EN_DISABLE;
    (*(ioport unsigned short *) (DSP_DMA_CICR0 + (i << 5))) =
        DSP_DMA_CICR_BASE | DSP_DMA_CICR_BLOCKIE_ENABEL;
    (*(ioport unsigned short *) (DSP_DMA_CCR0 + (i << 5))) |=
        DSP_DMA_CCR_EN_ENABLE;
    return 0;
}
